


-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
-- Here we build the network with all the groups that have a name starting with DF CCCP AWACS and DF CCCP EWR.
DetectionSetGroup = SET_GROUP:New()
DetectionSetGroup:FilterPrefixes( { "RedEW" } )
DetectionSetGroup:FilterStart()

Detection = DETECTION_AREAS:New( DetectionSetGroup, 30000 )

-- Setup the A2A dispatcher, and initialize it.
A2ADispatcher = AI_A2A_DISPATCHER:New( Detection )
-- A2ADispatcher_Red = AI_A2A_DISPATCHER:New( EWR_Red )

-- Initialize the dispatcher, setting up a radius of 100km where any airborne friendly 
-- without an assignment within 100km radius from a detected target, will engage that target.
A2ADispatcher:SetEngageRadius( 50000 )

A2ADispatcher:SetGciRadius( 90000 )

A2ADispatcher:SetTacticalDisplay( false )


-- Setup the squadrons.

A2ADispatcher:SetSquadron( "Azak", AIRBASE.Sinai.AzZaqaziq, { "SQ MiG19P Azak" })
A2ADispatcher:SetSquadronGci( "Azak", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Azak", 2 )

A2ADispatcher:SetSquadron( "Bilbeis", AIRBASE.Sinai.Bilbeis_Air_Base, { "SQ MiG21 Bilb" })
A2ADispatcher:SetSquadronGci( "Bilbeis", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Bilbeis", 2 )

A2ADispatcher:SetSquadron( "As", AIRBASE.Sinai.As_Salihiyah, { "SQ MiG21 AS" })
A2ADispatcher:SetSquadronGci( "As", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "As", 2 )

A2ADispatcher:SetSquadron( "Wadi", AIRBASE.Sinai.Wadi_al_Jandali, { "SQ MiG19P Wadi" })
A2ADispatcher:SetSquadronGci( "Wadi", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Wadi", 2 )



A2ADispatcher:SetDefaultTakeoffInAir()
A2ADispatcher:SetDefaultLandingNearAirbase()
A2ADispatcher:SetDisengageRadius( 90000 ) -- 300000 is the default value.



-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
-- Here we build the network with all the groups that have a name starting with DF CCCP AWACS and DF CCCP EWR.
DetectionSetGroup = SET_GROUP:New()
DetectionSetGroup:FilterPrefixes( { "BLueEW" } )
DetectionSetGroup:FilterStart()

Detection = DETECTION_AREAS:New( DetectionSetGroup, 30000 )

-- Setup the A2A dispatcher, and initialize it.
A2ADispatcher = AI_A2A_DISPATCHER:New( Detection )
-- A2ADispatcher_BLue = AI_A2A_DISPATCHER:New( EWR_BLue )

-- Initialize the dispatcher, setting up a radius of 100km where any airborne friendly 
-- without an assignment within 100km radius from a detected target, will engage that target.
A2ADispatcher:SetEngageRadius( 50000 )

A2ADispatcher:SetGciRadius( 90000 )

A2ADispatcher:SetTacticalDisplay( false )


-- Setup the squadrons.

A2ADispatcher:SetSquadron( "Ramon", AIRBASE.Sinai.Ramon_Airbase, { "SQ F4C Ram" })
A2ADispatcher:SetSquadronGci( "Ramon", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Ramon", 2 )

A2ADispatcher:SetSquadron( "Mez", AIRBASE.Sinai.Melez, { "SQ Mirage Mel" })
A2ADispatcher:SetSquadronGci( "Mez", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Mez", 2 )

A2ADispatcher:SetSquadron( "Bir", AIRBASE.Sinai.Bir_Hasanah, { "SQ Mirage Bir" })
A2ADispatcher:SetSquadronGci( "Bir", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Bir", 2 )

A2ADispatcher:SetSquadron( "Gora", AIRBASE.Sinai.El_Gora, { "SQ A4E Gora" })
A2ADispatcher:SetSquadronGci( "Gora", 900, 1200 )
A2ADispatcher:SetSquadronGrouping( "Gora", 2 )


A2ADispatcher:SetDefaultTakeoffInAir()
A2ADispatcher:SetDefaultLandingNearAirbase()
A2ADispatcher:SetDisengageRadius( 90000 ) -- 300000 is the default value.

